
(() => {
    "use strict";

    /* ===============================
       DOMAIN DETECTION (RIGHT CLICK)
       =============================== */

    window.__lastRightClickDomain = "";

    const DOMAIN_REGEX = /\b((?:[a-z0-9-]+\.)+[a-z]{2,})\b/i;

    document.addEventListener(
        "contextmenu",
        (e) => {
            let domain = "";
            const link = e.target.closest("a");

            if (link && link.innerText) {
                const match = link.innerText.match(DOMAIN_REGEX);
                if (match && match[1]) domain = match[1];
            }

            if (!domain && link?.href) {
                try {
                    domain = new URL(link.href).hostname;
                } catch { }
            }

            if (!domain && window.getSelection) {
                const selectedText = window.getSelection().toString();
                const match = selectedText.match(DOMAIN_REGEX);
                if (match && match[1]) domain = match[1];
            }

            if (domain) window.__lastRightClickDomain = domain.replace(/^www\./, "");
        },
        true
    );

    document.addEventListener("contextmenu", (e) => {
        // Only run on Sheets
        if (!location.href.includes("docs.google.com/spreadsheets")) return;

        let selectedText = "";
        // Get the selected cell text
        const selection = window.getSelection();
        if (selection && selection.toString().trim()) {
            selectedText = selection.toString().trim();
        }

        if (selectedText) {
            window.__lastRightClickDomain = selectedText.replace(/^www\./, "");
        }
    }, true);

})();

/* ===============================
   GOOGLE RESULTS COUNT INJECTION
   =============================== */
(function () {
    "use strict";

    // Global store
    window.__googleCountByDomain = window.__googleCountByDomain || {};

    function getDomainFromQuery() {
        const qInput = document.querySelector('input[name="q"]');
        if (!qInput) return null;
        const match = qInput.value.match(/site:([\w.-]+)/i);
        return match ? match[1].replace(/^www\./, "") : null;
    }

    function getTotalCount() {
        const selectors = [
            "#result-stats",
            ".LHJvCe",
            'div[role="heading"]'
        ];

        for (const selector of selectors) {
            const element = document.querySelector(selector);
            if (element) {
                const text = element.textContent || element.innerText;
                const match = text.match(/About ([\d,]+) results/i)
                    || text.match(/([\d,]+)\s+results/i)
                    || text.match(/(\d{1,3}(?:,\d{3})*)/);
                if (match && match[1]) return match[1];
            }
        }
        return "0";
    }

    function injectResultsDiv() {
        const domain = getDomainFromQuery();
        if (!domain) return;

        // Use stored count if available
        let count = window.__googleCountByDomain[domain] || getTotalCount();
        window.__googleCountByDomain[domain] = count;

        // Create or update div
        let resultsDiv = document.getElementById("custom-results-count");
        if (!resultsDiv) {
            resultsDiv = document.createElement("div");
            resultsDiv.id = "custom-results-count";
            resultsDiv.style.display = "inline-block";
            resultsDiv.style.fontSize = "16px";
            resultsDiv.style.border = "1px solid rgb(60,64,67)";
            resultsDiv.style.borderRadius = "20px";
            resultsDiv.style.padding = "10px 15px";
            resultsDiv.style.marginBottom = "30px";
        }

        resultsDiv.innerHTML = '';
        const textNode = document.createTextNode(`about ${count} results `);
        resultsDiv.appendChild(textNode);

        // Insert near top of results
        const searchHeader = document.querySelector("#search") || document.body;
        if (!document.getElementById("custom-results-count")) {
            searchHeader.prepend(resultsDiv);
        }
    }

    function waitForResults() {
        const searchHeader = document.querySelector("#search") || document.body;
        if (searchHeader) {
            injectResultsDiv();
        } else {
            setTimeout(waitForResults, 500);
        }
    }

    window.addEventListener("load", () => {
        waitForResults();
    });

})();